/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.keys;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.client.screens.ToolModeSelectionScreen;
import mod.chiselsandbits.client.time.TickHandler;
import mod.chiselsandbits.keys.contexts.HoldsSpecificItemInHandKeyConflictContext;
import mod.chiselsandbits.keys.contexts.HoldsWithToolItemInHandKeyConflictContext;
import mod.chiselsandbits.keys.contexts.SpecificScreenOpenKeyConflictContext;
import mod.chiselsandbits.network.packets.HeldToolModeChangedPacket;
import mod.chiselsandbits.network.packets.RequestChangeTrackerOperationPacket;
import mod.chiselsandbits.platforms.core.client.key.IKeyBindingManager;
import mod.chiselsandbits.platforms.core.client.key.KeyModifier;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public class KeyBindingManager {
    private static final KeyBindingManager INSTANCE = new KeyBindingManager();
    private class_304 openToolMenuKeybinding = null;
    private class_304 cycleToolMenuLeftKeybinding = null;
    private class_304 cycleToolMenuRightKeybinding = null;
    private class_304 resetMeasuringTapeKeyBinding = null;
    private class_304 undoOperationKeyBinding = null;
    private class_304 redoOperationKeyBinding = null;
    private class_304 scopingKeyBinding = null;
    private boolean toolMenuKeyWasDown = false;
    private int toolModeSelectionPlusCoolDown = 15;
    private int toolModeSelectionMinusCoolDown = 15;
    private long lastChangeTime = -10L;
    private boolean initialized = false;

    private KeyBindingManager() {
    }

    public static KeyBindingManager getInstance() {
        return INSTANCE;
    }

    public void onModInitialization() {
        this.openToolMenuKeybinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.modded-tool.open", HoldsWithToolItemInHandKeyConflictContext.getInstance(), class_3675.class_307.field_1668, 82, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.openToolMenuKeybinding);
        this.cycleToolMenuLeftKeybinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.modded-tool.cycle.left", SpecificScreenOpenKeyConflictContext.RADIAL_TOOL_MENU, class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.cycleToolMenuLeftKeybinding);
        this.cycleToolMenuRightKeybinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.modded-tool.cycle.right", SpecificScreenOpenKeyConflictContext.RADIAL_TOOL_MENU, class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.cycleToolMenuRightKeybinding);
        this.resetMeasuringTapeKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.measuring-tape.reset", HoldsSpecificItemInHandKeyConflictContext.MEASURING_TAPE, KeyModifier.SHIFT, class_3675.class_307.field_1672, 1, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.resetMeasuringTapeKeyBinding);
        this.undoOperationKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.undo", HoldsSpecificItemInHandKeyConflictContext.CHANGE_TRACKING_ITEM, KeyModifier.CONTROL, class_3675.class_307.field_1668, 90, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.undoOperationKeyBinding);
        this.redoOperationKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.redo", HoldsSpecificItemInHandKeyConflictContext.CHANGE_TRACKING_ITEM, KeyModifier.CONTROL, class_3675.class_307.field_1668, 89, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.redoOperationKeyBinding);
        this.scopingKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.zoom", HoldsSpecificItemInHandKeyConflictContext.CHANGE_TRACKING_ITEM, class_3675.class_307.field_1668, 90, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.scopingKeyBinding);
        this.initialized = true;
    }

    public void handleKeyPresses() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null) {
            class_1799 inHand;
            boolean toolMenuKeyIsDown = this.isOpenToolMenuKeyPressed();
            if (toolMenuKeyIsDown && !this.toolMenuKeyWasDown && this.isOpenToolMenuKeyPressed() && mc.field_1755 == null && !(inHand = ItemStackUtils.getModeItemStackFromPlayer((class_1657)mc.field_1724)).method_7960() && inHand.method_7909() instanceof IWithModeItem) {
                try {
                    mc.method_1507(ToolModeSelectionScreen.create(inHand));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            this.toolMenuKeyWasDown = true;
        }
        if (ItemStackUtils.getModeItemStackFromPlayer((class_1657)class_310.method_1551().field_1724).method_7909() instanceof IWithModeItem) {
            class_1799 stack = ItemStackUtils.getModeItemStackFromPlayer((class_1657)class_310.method_1551().field_1724);
            IWithModeItem withModeItem = (IWithModeItem)stack.method_7909();
            ArrayList candidates = Lists.newArrayList(withModeItem.getPossibleModes());
            Object cur = withModeItem.getMode(stack);
            int workingIndex = candidates.indexOf(cur);
            if (this.toolModeSelectionPlusCoolDown == 15 && this.isCycleToolMenuRightKeyPressed()) {
                if (++workingIndex >= candidates.size()) {
                    workingIndex = 0;
                }
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(workingIndex));
                this.toolModeSelectionPlusCoolDown = 0;
            } else if (this.isCycleToolMenuRightKeyPressed() && this.toolModeSelectionPlusCoolDown <= 14) {
                ++this.toolModeSelectionPlusCoolDown;
            } else if (this.toolModeSelectionMinusCoolDown == 15 && this.isCycleToolMenuLeftKeyPressed()) {
                if (--workingIndex < 0) {
                    workingIndex = candidates.size() - 1;
                }
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(workingIndex));
                this.toolModeSelectionMinusCoolDown = 0;
            } else if (this.isCycleToolMenuLeftKeyPressed() && this.toolModeSelectionMinusCoolDown <= 14) {
                ++this.toolModeSelectionMinusCoolDown;
            }
        }
        if (!this.isCycleToolMenuRightKeyPressed()) {
            this.toolModeSelectionPlusCoolDown = 15;
        }
        if (!this.isCycleToolMenuLeftKeyPressed()) {
            this.toolModeSelectionMinusCoolDown = 15;
        }
        if (this.isUndoOperationKeyPressed() && TickHandler.getClientTicks() - this.lastChangeTime > 10L) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new RequestChangeTrackerOperationPacket(false));
            this.lastChangeTime = TickHandler.getClientTicks();
        }
        if (this.isRedoOperationKeyPressed() && TickHandler.getClientTicks() - this.lastChangeTime > 10L) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new RequestChangeTrackerOperationPacket(true));
            this.lastChangeTime = TickHandler.getClientTicks();
        }
    }

    public boolean hasBeenInitialized() {
        return this.initialized;
    }

    public boolean isOpenToolMenuKeyPressed() {
        return this.isKeyDown(this.getOpenToolMenuKeybinding());
    }

    public boolean isCycleToolMenuRightKeyPressed() {
        return this.isKeyDown(this.getCycleToolMenuRightKeybinding());
    }

    public boolean isCycleToolMenuLeftKeyPressed() {
        return this.isKeyDown(this.getCycleToolMenuLeftKeybinding());
    }

    public boolean isUndoOperationKeyPressed() {
        return this.isKeyDown(this.getUndoOperationKeyBinding());
    }

    public boolean isRedoOperationKeyPressed() {
        return this.isKeyDown(this.getRedoOperationKeyBinding());
    }

    public boolean isKeyDown(class_304 keybinding) {
        if (keybinding.method_1415()) {
            return false;
        }
        boolean isDown = switch (keybinding.field_1655.method_1442()) {
            case class_3675.class_307.field_1668 -> class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)keybinding.field_1655.method_1444());
            case class_3675.class_307.field_1672 -> {
                if (GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)keybinding.field_1655.method_1444()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        return (isDown || keybinding.method_1434()) && IKeyBindingManager.getInstance().isKeyConflictOfActive(keybinding) && IKeyBindingManager.getInstance().isKeyModifierActive(keybinding);
    }

    public class_304 getOpenToolMenuKeybinding() {
        if (this.openToolMenuKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.openToolMenuKeybinding;
    }

    public class_304 getCycleToolMenuRightKeybinding() {
        if (this.cycleToolMenuRightKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.cycleToolMenuRightKeybinding;
    }

    public class_304 getCycleToolMenuLeftKeybinding() {
        if (this.cycleToolMenuLeftKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.cycleToolMenuLeftKeybinding;
    }

    public class_304 getUndoOperationKeyBinding() {
        if (this.undoOperationKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.undoOperationKeyBinding;
    }

    public class_304 getRedoOperationKeyBinding() {
        if (this.redoOperationKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.redoOperationKeyBinding;
    }

    public boolean isResetMeasuringTapeKeyPressed() {
        return this.isKeyDown(this.getResetMeasuringTapeKeyBinding());
    }

    public class_304 getResetMeasuringTapeKeyBinding() {
        if (this.resetMeasuringTapeKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.resetMeasuringTapeKeyBinding;
    }

    public class_304 getScopingKeyBinding() {
        if (this.scopingKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.scopingKeyBinding;
    }

    public boolean isScopingKeyPressed() {
        return this.isKeyDown(this.getScopingKeyBinding());
    }
}

